import crafttweaker.item.IIngredient;

import mods.zenstages.ZenStager;

import scripts.crafttweaker.stages.stageOne;
import scripts.crafttweaker.stages.stageTwo;
import scripts.crafttweaker.stages.stageThree;
import scripts.crafttweaker.stages.stageFour;
import scripts.crafttweaker.stages.stageDisabled;
import scripts.crafttweaker.stages.stageCreativeUnused;

static stagedItems as IIngredient[][string] = {
	stageOne.stage: [
		<bloodmagic:altar:0>,
		<bloodmagic:arcane_ashes:0>,
		<bloodmagic:blood_orb:0>.withTag({orb: "bloodmagic:apprentice"}),
		<bloodmagic:blood_orb:0>.withTag({orb: "bloodmagic:weak"}),
		<bloodmagic:blood_rune:1>,
		<bloodmagic:blood_rune:2>,
		<bloodmagic:blood_rune:3>,
		<bloodmagic:blood_rune:4>,
		<bloodmagic:blood_rune:0>,
		<bloodmagic:component:5>,
		<bloodmagic:component:11>,
		<bloodmagic:component:27>,
		<bloodmagic:component:31>,
		<bloodmagic:component:32>,
		<bloodmagic:dagger_of_sacrifice:0>,
		<bloodmagic:incense_altar:0>,
		<bloodmagic:monster_soul:0>,
		<bloodmagic:path:1>,
		<bloodmagic:path:0>,
		<bloodmagic:sacrificial_dagger:0>,
		<bloodmagic:sanguine_book:0>,
		<bloodmagic:sentient_sword:*>,
		<bloodmagic:sigil_blood_light:0>,
		<bloodmagic:sigil_bounce:0>,
		<bloodmagic:sigil_divination:0>,
		<bloodmagic:sigil_frost:0>,
		<bloodmagic:sigil_green_grove:0>,
		<bloodmagic:sigil_holding:0>,
		<bloodmagic:slate:1>,
		<bloodmagic:slate:0>,
		<bloodmagic:soul_forge:0>,
		<bloodmagic:soul_gem:1>,
		<bloodmagic:soul_gem:0>,
		<bloodmagic:soul_snare:0>
	],

	stageTwo.stage: [
		<bloodmagic:activation_crystal:0>,
		<bloodmagic:blood_orb:0>.withTag({orb: "bloodmagic:magician"}),
		<bloodmagic:blood_rune:5>,
		<bloodmagic:blood_rune:6>,
		<bloodmagic:blood_rune:9>,
		<bloodmagic:component:3>,
		<bloodmagic:component:4>,
		<bloodmagic:component:12>,
		<bloodmagic:component:0>,
		<bloodmagic:demon_will_gauge:0>,
		<bloodmagic:experience_tome:0>,
		<bloodmagic:inscription_tool:1>,
		<bloodmagic:lava_crystal:0>,
		<bloodmagic:pack_sacrifice:0>,
		<bloodmagic:pack_self_sacrifice:0>,
		<bloodmagic:path:2>,
		<bloodmagic:path:3>,
		<bloodmagic:sentient_axe:*>,
		<bloodmagic:sentient_bow:0>,
		<bloodmagic:sentient_pickaxe:*>,
		<bloodmagic:sentient_shovel:*>,
		<bloodmagic:sigil_fast_miner:0>,
		<bloodmagic:sigil_magnetism:0>,
		<bloodmagic:sigil_void:0>,
		<bloodmagic:sigil_water:0>,
		<bloodmagic:sigil_whirlwind:0>,
		<bloodmagic:slate:2>,
		<bloodmagic:soul_gem:2>
	],

	stageThree.stage: [
		<bloodmagic:activation_crystal:1>,
		<bloodmagic:alchemic_vial:0>,
		<bloodmagic:alchemy_table:0>,
		<bloodmagic:base_fluid_filter:0>,
		<bloodmagic:base_item_filter:1>,
		<bloodmagic:base_item_filter:2>,
		<bloodmagic:base_item_filter:3>,
		<bloodmagic:base_item_filter:0>,
		<bloodmagic:blood_orb:0>.withTag({orb: "bloodmagic:archmage"}),
		<bloodmagic:blood_orb:0>.withTag({orb: "bloodmagic:master"}),
		<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:transcendent"}),
		<bloodmagic:blood_rune:7>,
		<bloodmagic:blood_rune:8>,
		<bloodmagic:blood_rune:9>,
		<bloodmagic:blood_rune:10>,
		<bloodmagic:blood_shard:1>,
		<bloodmagic:blood_shard:0>,
		<bloodmagic:blood_tank:*>,
		<bloodmagic:bound_axe:*>,
		<bloodmagic:bound_pickaxe:*>,
		<bloodmagic:bound_shovel:*>,
		<bloodmagic:bound_sword:*>,
		<bloodmagic:component:1>,
		<bloodmagic:component:6>,
		<bloodmagic:component:7>,
		<bloodmagic:component:8>,
		<bloodmagic:component:9>,
		<bloodmagic:component:10>,
		<bloodmagic:component:13>,
		<bloodmagic:component:15>,
		<bloodmagic:component:16>,
		<bloodmagic:component:17>,
		<bloodmagic:component:18>,
		<bloodmagic:component:22>,
		<bloodmagic:component:23>,
		<bloodmagic:component:24>,
		<bloodmagic:component:25>,
		<bloodmagic:component:26>,
		<bloodmagic:component:28>,
		<bloodmagic:component:29>,
		<bloodmagic:component:30>,
		<bloodmagic:cutting_fluid:1>,
		<bloodmagic:cutting_fluid:0>,
		<bloodmagic:decorative_brick:1>,
		<bloodmagic:decorative_brick:2>,
		<bloodmagic:decorative_brick:3>,
		<bloodmagic:decorative_brick:0>,
		<bloodmagic:demon_brick_1:*>,
		<bloodmagic:demon_brick_2:*>,
		<bloodmagic:demon_crucible:0>,
		<bloodmagic:demon_crystal:4>,
		<bloodmagic:demon_crystal:3>,
		<bloodmagic:demon_crystal:2>,
		<bloodmagic:demon_crystal:1>,
		<bloodmagic:demon_crystal:0>,
		<bloodmagic:demon_crystallizer:0>,
		<bloodmagic:demon_extras:*>,
		<bloodmagic:demon_light:*>,
		<bloodmagic:demon_pillar_1:*>,
		<bloodmagic:demon_pillar_2:*>,
		<bloodmagic:demon_pillar_cap_1:*>,
		<bloodmagic:demon_pillar_cap_2:*>,
		<bloodmagic:demon_pillar_cap_3:*>,
		<bloodmagic:demon_pylon:0>,
		<bloodmagic:demon_stairs_1:*>,
		<bloodmagic:demon_stairs_2:*>,
		<bloodmagic:demon_stairs_3:*>,
		<bloodmagic:demon_wall_1:*>,
		<bloodmagic:input_routing_node:0>,
		<bloodmagic:inscription_tool:2>,
		<bloodmagic:inscription_tool:3>,
		<bloodmagic:inscription_tool:4>,
		<bloodmagic:inscription_tool:5>,
		<bloodmagic:inscription_tool:6>,
		<bloodmagic:inversion_pillar_end:*>,
		<bloodmagic:inversion_pillar:*>,
		<bloodmagic:item_demon_crystal:*>,
		<bloodmagic:item_routing_node:0>,
		<bloodmagic:living_armour_boots:*>,
		<bloodmagic:living_armour_chest:*>,
		<bloodmagic:living_armour_helmet:*>,
		<bloodmagic:living_armour_leggings:*>,
		<bloodmagic:master_routing_node:0>,
		<bloodmagic:mimic:1>,
		<bloodmagic:mimic:2>,
		<bloodmagic:mimic:3>,
		<bloodmagic:mimic:4>,
		<bloodmagic:mimic:0>,
		<bloodmagic:monster_soul:1>,
		<bloodmagic:monster_soul:2>,
		<bloodmagic:monster_soul:3>,
		<bloodmagic:monster_soul:4>,
		<bloodmagic:node_router:0>,
		<bloodmagic:output_routing_node:0>,
		<bloodmagic:path:4>,
		<bloodmagic:path:5>,
		<bloodmagic:path:6>,
		<bloodmagic:path:7>,
		<bloodmagic:points_upgrade:0>,
		<bloodmagic:potion_flask:0>,
		<bloodmagic:ritual_controller:1>,
		<bloodmagic:ritual_controller:2>,
		<bloodmagic:ritual_controller:0>,
		<bloodmagic:ritual_dismantler:0>,
		<bloodmagic:ritual_diviner:1>,
		<bloodmagic:ritual_diviner:2>,
		<bloodmagic:ritual_diviner:0>,
		<bloodmagic:ritual_reader:0>,
		<bloodmagic:ritual_stone:1>,
		<bloodmagic:ritual_stone:2>,
		<bloodmagic:ritual_stone:3>,
		<bloodmagic:ritual_stone:4>,
		<bloodmagic:ritual_stone:5>,
		<bloodmagic:ritual_stone:6>,
		<bloodmagic:ritual_stone:0>,
		<bloodmagic:sentient_armour_boots:*>,
		<bloodmagic:sentient_armour_chest:*>,
		<bloodmagic:sentient_armour_gem:0>,
		<bloodmagic:sentient_armour_helmet:*>,
		<bloodmagic:sentient_armour_leggings:*>,
		<bloodmagic:sigil_claw:0>,
		<bloodmagic:sigil_elemental_affinity:0>,
		<bloodmagic:sigil_ender_severance:0>,
		<bloodmagic:sigil_haste:0>,
		<bloodmagic:sigil_lava:0>,
		<bloodmagic:sigil_phantom_bridge:0>,
		<bloodmagic:sigil_seer:0>,
		<bloodmagic:sigil_suppression:0>,
		<bloodmagic:sigil_teleposition:0>,
		<bloodmagic:sigil_transposition:0>,
		<bloodmagic:slate:3>,
		<bloodmagic:slate:4>,
		<bloodmagic:soul_gem:1>.withTag({souls: 256.0, demonWillType: "corrosive"}),
		<bloodmagic:soul_gem:1>.withTag({souls: 256.0, demonWillType: "destructive"}),
		<bloodmagic:soul_gem:1>.withTag({souls: 256.0, demonWillType: "steadfast"}),
		<bloodmagic:soul_gem:1>.withTag({souls: 256.0, demonWillType: "vengeful"}),
		<bloodmagic:soul_gem:2>.withTag({souls: 1024.0, demonWillType: "corrosive"}),
		<bloodmagic:soul_gem:2>.withTag({souls: 1024.0, demonWillType: "destructive"}),
		<bloodmagic:soul_gem:2>.withTag({souls: 1024.0, demonWillType: "steadfast"}),
		<bloodmagic:soul_gem:2>.withTag({souls: 1024.0, demonWillType: "vengeful"}),
		<bloodmagic:soul_gem:3>,
		<bloodmagic:soul_gem:3>.withTag({souls: 4096.0, demonWillType: "corrosive"}),
		<bloodmagic:soul_gem:3>.withTag({souls: 4096.0, demonWillType: "destructive"}),
		<bloodmagic:soul_gem:3>.withTag({souls: 4096.0, demonWillType: "steadfast"}),
		<bloodmagic:soul_gem:3>.withTag({souls: 4096.0, demonWillType: "vengeful"}),
		<bloodmagic:soul_gem:4>,
		<bloodmagic:soul_gem:4>.withTag({souls: 16384.0, demonWillType: "corrosive"}),
		<bloodmagic:soul_gem:4>.withTag({souls: 16384.0, demonWillType: "destructive"}),
		<bloodmagic:soul_gem:4>.withTag({souls: 16384.0, demonWillType: "steadfast"}),
		<bloodmagic:soul_gem:4>.withTag({souls: 16384.0, demonWillType: "vengeful"}),
		<bloodmagic:teleposer:0>,
		<bloodmagic:teleposition_focus:1>,
		<bloodmagic:teleposition_focus:2>,
		<bloodmagic:teleposition_focus:3>,
		<bloodmagic:teleposition_focus:0>,
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.crippledArm"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.elytra"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.quenched"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.repair"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.slippery"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 0, key: "bloodmagic.upgrade.stepAssist"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.arrowShot"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.battleHunger"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.criticalStrike"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.fallProtect"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.fireResist"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.knockback"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.poisonResist"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.sprintAttack"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 4, key: "bloodmagic.upgrade.stormTrooper"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.digging"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.digSlowdown"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.disoriented"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.experienced"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.graveDigger"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.grimReaper"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.health"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.jump"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.meleeDamage"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.meleeDecrease"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.movement"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.nightSight"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.physicalProtect"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.selfSacrifice"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.slowHeal"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.slowness"}),
		<bloodmagic:upgrade_tome:0>.withTag({level: 9, key: "bloodmagic.upgrade.solarPowered"}),
		<bloodmagic:upgrade_trainer:0>,
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.arrowShot"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.battleHunger"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.crippledArm"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.criticalStrike"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.digging"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.digSlowdown"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.disoriented"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.elytra"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.experienced"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.fallProtect"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.fireResist"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.graveDigger"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.grimReaper"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.health"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.jump"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.knockback"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.meleeDamage"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.meleeDecrease"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.movement"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.nightSight"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.physicalProtect"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.poisonResist"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.quenched"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.repair"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.selfSacrifice"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.slippery"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.slowHeal"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.slowness"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.solarPowered"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.sprintAttack"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.stepAssist"}),
		<bloodmagic:upgrade_trainer:0>.withTag({key: "bloodmagic.upgrade.stormTrooper"})
	],

	stageFour.stage: [
		<bloodmagic:component:2>,
		<bloodmagic:sigil_air:0>
	],

	stageCreativeUnused.stage: [
		<bloodmagic:activation_crystal:2>,
		<bloodmagic:altar_maker:0>,
		<bloodmagic:sacrificial_dagger:1>
	]
};

static hiddenItems as IIngredient[] = [
	<bloodmagic:blood_rune:2> // TODO: Remove this one the mod its self adds functionality to the block / adds a recipe.
];

static hiddenRemove as IIngredient[] = [
	<bloodmagic:component:14>,
	<bloodmagic:sigil_compression:0>
];

function init() {
	var modId as string = stagedItems.entrySet[0].value[0].items[0].definition.owner;

	var modStage as string = scripts.crafttweaker.staging.itemsAndRecipes.modId.containsMod(modId);
	var doOverride as bool = modStage != "";

	for stageName, items in stagedItems {
		if (doOverride && stageName != modStage) {
			ZenStager.addModItemOverrides(modId, items);
		}

		ZenStager.getStage(stageName).addIngredients(items);
	}
	recipeUtil.hideItems(hiddenItems as IIngredient[]);
	recipeUtil.hideItems(hiddenRemove as IIngredient[], true);
}
